;*****************************************************************************        
;
;   Module:     calc.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 5/10/03                                                  
;
;               general BCD math routines
;
;*****************************************************************************        



;*****************************************************************************        
;
;   Function :  calcBCDSubByteWord
;               subtracts byteBCDTmpA from wordBCDTmpA
;               Words are 6 digit BCD
;
;   Input:      byteBCDTmpA, wordBCDTmpA. 
;
;   Output:     byteBCDTmpA unchanged
;               Carry clear on overflow
;
;*****************************************************************************        
calcBCDSubByteWord
    movf    byteBCDTmpA, W    
    subwf   wordBCDTmpA2, W    
    rlf     wordBCDTmpA2, F    
    btfss   STATUS,DC          
    addlw  -0x06   
                    
    btfss   wordBCDTmpA2, 0   
    addlw  -0x60 
    rrf     wordBCDTmpA2, F    
    movwf   wordBCDTmpA2       
    btfsc   STATUS, C
    return
    
    movlw   0x01
    subwf   wordBCDTmpA1, W    
    rlf     wordBCDTmpA1, F   
    btfss   STATUS,DC           
    addlw  -0x06   
                   
    btfss   wordBCDTmpA1, 0     
    addlw  -0x60 
    rrf     wordBCDTmpA1, F    
    movwf   wordBCDTmpA1       
    btfsc   STATUS, C
    return
    
    movlw   0x01
    subwf   wordBCDTmpA0, W    
    rlf     wordBCDTmpA0, F   
    btfss   STATUS,DC          
    addlw  -0x06  
                     
    btfss   wordBCDTmpA0, 0   
    addlw  -0x60 
    rrf     wordBCDTmpA0, F    
    movwf   wordBCDTmpA0       
    return 



;*****************************************************************************        
;
;   Function :  calcBCDDivWord
;               Divides wordBCDTmpA by wordBCDTmpB
;               Words are 6 digit BCD
;
;   Input:      wordBCDTmpB, wordBCDTmpA. 
;
;   Output:     wordBCDTmpB unchanged
;               All inputs unchanged if wordBCDTmpB == 0
;               result in byteBCDTmpA
;
;*****************************************************************************        
calcBCDDivWord
    clrf    byteBCDTmpA
    
    ; Check that the divisor is non zero; Exit if it is
    movfw   wordBCDTmpB0
    sublw   0x00
    btfss   STATUS, Z
    goto    cbdw_001
    movfw   wordBCDTmpB1
    sublw   0x00
    btfss   STATUS, Z
    goto    cbdw_001
    movfw   wordBCDTmpB2
    sublw   0x00
    btfsc   STATUS, Z
    goto    cbdw_exit           ; It's 0, so do nothing
    
cbdw_001
    ; Perform a division by repeated subtraction.
    ; This always rounds up, but the accuracy is
    ; good enough for what we are doing.
    
    ; increment byteBCDTmpA by 1
    movlw   0xFE
    addlw   0x9a+1                      
    subwf   byteBCDTmpA, W 
    rlf     byteBCDTmpA, F  
    skpdc           
    addlw  -0x06  
    btfss   byteBCDTmpA, 0   
    addlw  -0x60 
    movwf   byteBCDTmpA 
    
    call    calcBCDSubWord
    btfsc   STATUS, C           ; Carry is clear on overflow
    goto    cbdw_002
    goto    cbdw_exit
    
cbdw_002
    ; Test for zero before looping back
    movfw   wordBCDTmpA0
    sublw   0x00
    btfss   STATUS,Z
    goto    cbdw_001
    movfw   wordBCDTmpA1
    sublw   0x00
    btfss   STATUS,Z
    goto    cbdw_001
    movfw   wordBCDTmpA2
    sublw   0x00
    btfss   STATUS,Z
    goto    cbdw_001
    
cbdw_exit
    return



;*****************************************************************************        
;
;   Function :  calcBCDSubWord
;               subtracts wordBCDTmpB from wordBCDTmpA
;               Words are 6 digit BCD
;
;   Input:      wordBCDTmpB, wordBCDTmpA. 
;
;   Output:     wordBCDTmpB unchanged
;               Carry clear on overflow
;
;*****************************************************************************        
calcBCDSubWord
    movf    wordBCDTmpB2, W   
    subwf   wordBCDTmpA2, W    
    rlf     wordBCDTmpA2, F  
    btfss   STATUS,DC          
    addlw  -0x06   
                 
    btfss   wordBCDTmpA2, 0    
    addlw  -0x60 
    rrf     wordBCDTmpA2, F     
    movwf   wordBCDTmpA2       
    movlw   1
    btfsc   STATUS, C
    movlw   0
    addwf   wordBCDTmpB1, W
    
    subwf   wordBCDTmpA1, W    
    rlf     wordBCDTmpA1, F    
    btfss   STATUS,DC           
    addlw  -0x06   
                   
    btfss   wordBCDTmpA1, 0   
    addlw  -0x60 
    rrf     wordBCDTmpA1, F   
    movwf   wordBCDTmpA1   

    movlw   1
    btfsc   STATUS, C
    movlw   0
    addwf   wordBCDTmpB0, W
    subwf   wordBCDTmpA0, W   
    rlf     wordBCDTmpA0, F    
    btfss   STATUS,DC          
    addlw  -0x06  
                   
    btfss   wordBCDTmpA0, 0    
    addlw  -0x60 
    rrf     wordBCDTmpA0, F   
    movwf   wordBCDTmpA0       
    return 


  
;*****************************************************************************        
;
;   Function :  calcBCDAddByte2Word
;               Adds byteBCDTmpA to wordBCDTmpA
;               Words are 6 digit BCD
;
;   Input:      byteBCDTmpA, wordBCDTmpA. 
;
;   Output:     byteBCDTmpA unchanged
;               Carry set on overflow
;
;*****************************************************************************        
calcBCDAddByte2Word
    comf    byteBCDTmpA, W 
    addlw   0x9a+1                      
                   
    subwf   wordBCDTmpA2, W 
                                        
    rlf     wordBCDTmpA2, F  
    skpdc           
    addlw  -0x06  
    btfss   wordBCDTmpA2, 0   
    addlw  -0x60 
    rrf     wordBCDTmpA2, F    
    movwf   wordBCDTmpA2 
    
    btfss   STATUS, C
    return
    
    ; Add 1 to next byte
    
    movlw   0x99
    subwf   wordBCDTmpA1, W    
                                      
    rlf     wordBCDTmpA1, F    
    skpdc          
    addlw  -0x06   
    btfss   wordBCDTmpA1, 0  
    addlw  -0x60 
    rrf     wordBCDTmpA1, F  
    movwf   wordBCDTmpA1 
    
    btfss   STATUS, C
    return
    
    movlw   0x99
    subwf   wordBCDTmpA0, W    
                                    
    rlf     wordBCDTmpA0, F   
    skpdc           
    addlw  -0x06   
    btfss   wordBCDTmpA0, 0 
    addlw  -0x60 
    rrf     wordBCDTmpA0, F   
    movwf   wordBCDTmpA0 
    return 


 
;*****************************************************************************        
;
;   Function :  calcBCDAdd2Words
;               Adds wordBCDTmpB to wordBCDTmpA
;               Words are 6 digit BCD
;
;   Input:      wordBCDTmpB, wordBCDTmpA. 
;
;   Output:     wordBCDTmpB *is* destroyed
;               Carry set on overflow
;
;*****************************************************************************        
calcBCDAdd2Words
    comf    wordBCDTmpB2, W  
    addlw   0x9a+1             
              
    subwf   wordBCDTmpA2, W   
                            
    rlf     wordBCDTmpA2, F   
    skpdc          
    addlw  -0x06  
    btfss   wordBCDTmpA2, 0   
    addlw  -0x60 
    rrf     wordBCDTmpA2, F   
    movwf   wordBCDTmpA2 
    
    btfsc   STATUS, C
    
    incf    wordBCDTmpB1, F
    
    comf    wordBCDTmpB1, W   
    addlw   0x9a+1  
    
    ; Add 1 to next byte, plus next byte in sequence
  
    subwf   wordBCDTmpA1, W  
                     
    rlf     wordBCDTmpA1, F 
    skpdc        
    addlw  -0x06  
    btfss   wordBCDTmpA1, 0 
    addlw  -0x60 
    rrf     wordBCDTmpA1, F   
    movwf   wordBCDTmpA1 
    
    btfsc   STATUS, C
    
    incf    wordBCDTmpB0, F
    
    comf    wordBCDTmpB0, W 
    addlw   0x9a+1 
    subwf   wordBCDTmpA0, W 
                             
    rlf     wordBCDTmpA0, F    
    skpdc           
    addlw  -0x06  
    btfss   wordBCDTmpA0, 0   
    addlw  -0x60 
    rrf     wordBCDTmpA0, F   
    movwf   wordBCDTmpA0    
    return


